/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalComparator;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ICommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.UserAgentFilterType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import com.aptana.ui.util.UIUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentAssistProcessor
implements IContentAssistProcessor,
ICommonContentAssistProcessor,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String DEFAULT_IMAGE = "icons/proposal.png";
    private static final String INSERT = "insert";
    private static final String DISPLAY = "display";
    private static final String IMAGE = "image";
    private static final String TOOL_TIP = "tool_tip";
    private static final String LOCATION = "location";
    private static final String PERFORMANCE_EVENT_PREFIX = "com.aptana.editor.common/perf/content_assist";
    private static final String RUBLE_PERF = "com.aptana.editor.common/perf/content_assist/rubles";
    private static final String SNIPPET_PERF = "com.aptana.editor.common/perf/content_assist/snippets";
    protected static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private char[] _completionProposalChars = null;
    private char[] _contextInformationChars = null;
    private char[] _proposalTriggerChars = null;
    private UserAgentFilterType _filterType = UserAgentFilterType.NO_FILTER;
    protected final AbstractThemeableEditor editor;

    public CommonContentAssistProcessor(AbstractThemeableEditor editor) {
        this.editor = editor;
        this._completionProposalChars = this.retrieveCAPreference("completionProposalActivationCharacters");
        this._contextInformationChars = this.retrieveCAPreference("contextInformationActivationCharacters");
        this._proposalTriggerChars = this.retrieveCAPreference("proposalTriggerCharacters");
        IPreferenceStore commonPreferences = CommonEditorPlugin.getDefault().getPreferenceStore();
        String filterTypeString = commonPreferences.getString("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE");
        this._filterType = UserAgentFilterType.get(filterTypeString);
        commonPreferences.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE".equals(event.getProperty())) {
                    CommonContentAssistProcessor.this._filterType = UserAgentFilterType.get(event.getNewValue().toString());
                }
            }
        });
        if (this.getPreferenceNodeQualifier() != null) {
            InstanceScope.INSTANCE.getNode(this.getPreferenceNodeQualifier()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    protected void addCompletionProposalsForCategory(ITextViewer viewer, int offset, Index index, List<ICompletionProposal> completionProposals, String category) {
        List queryResults = index.query(new String[]{category}, "", 1);
        if (queryResults != null) {
            for (QueryResult queryResult : queryResults) {
                String text = queryResult.getWord();
                int length = text.length();
                String info = String.valueOf(category) + " : " + text;
                completionProposals.add((ICompletionProposal)new CompletionProposal(text, offset, 0, length, null, text, null, info));
            }
        }
    }

    protected Collection<? extends ICompletionProposal> addRubleCAProposals(ITextViewer viewer, int offset, Ruby ruby, ContentAssistElement ce) {
        boolean recordPerf = PerformanceStats.isEnabled((String)RUBLE_PERF);
        PerformanceStats stats = null;
        CommandContext context = ce.createCommandContext();
        context.setInputStream((InputStream)new ByteArrayInputStream(viewer.getDocument().get().getBytes()));
        if (recordPerf) {
            stats = PerformanceStats.getStats((String)RUBLE_PERF, (Object)ce.getDisplayName());
            stats.startRun();
        }
        CommandResult result = ce.execute(context);
        if (recordPerf) {
            stats.endRun();
        }
        if (result == null || !result.executedSuccessfully()) {
            return Collections.emptyList();
        }
        String output = result.getOutputString();
        if (StringUtil.isEmpty((String)output)) {
            return Collections.emptyList();
        }
        RubyArray object = (RubyArray)ruby.evalScriptlet(output);
        RubySymbol insertSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)INSERT);
        RubySymbol displaySymbol = RubySymbol.newSymbol((Ruby)ruby, (String)DISPLAY);
        RubySymbol imageSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)IMAGE);
        RubySymbol tooltipSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)TOOL_TIP);
        RubySymbol locationSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)LOCATION);
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        IRubyObject[] iRubyObjectArray = object.toJavaArray();
        int n = iRubyObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                String displayName;
                int length;
                String name;
                Image image;
                int replaceLength;
                IContextInformation contextInfo;
                String location;
                String description;
                block18: {
                    IRubyObject element;
                    block16: {
                        element = iRubyObjectArray[n2];
                        description = null;
                        location = null;
                        contextInfo = null;
                        replaceLength = 0;
                        image = UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)DEFAULT_IMAGE);
                        if (!(element instanceof RubyHash)) break block16;
                        RubyHash hash = (RubyHash)element;
                        if (!hash.containsKey(insertSymbol)) break block17;
                        name = hash.get(insertSymbol).toString();
                        length = name.length();
                        displayName = hash.containsKey(displaySymbol) ? hash.get(displaySymbol).toString() : name;
                        if (hash.containsKey(locationSymbol)) {
                            location = hash.get(locationSymbol).toString();
                        }
                        if (hash.containsKey(imageSymbol)) {
                            String imagePath = hash.get(imageSymbol).toString();
                            ImageRegistry reg = CommonEditorPlugin.getDefault().getImageRegistry();
                            Image fromReg = reg.get(imagePath);
                            if (fromReg == null) {
                                URL imageURL = null;
                                try {
                                    imageURL = new URL(imagePath);
                                }
                                catch (MalformedURLException e) {
                                    try {
                                        imageURL = new File(imagePath).toURI().toURL();
                                    }
                                    catch (MalformedURLException e1) {
                                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e1);
                                    }
                                }
                                if (imageURL != null) {
                                    ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageURL);
                                    reg.put(imagePath, desc);
                                    image = reg.get(imagePath);
                                }
                            } else {
                                image = fromReg;
                            }
                        }
                        if (hash.containsKey(tooltipSymbol)) {
                            description = hash.get(tooltipSymbol).toString();
                        }
                        break block18;
                    }
                    displayName = name = element.toString();
                    length = name.length();
                }
                CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
                if (location != null) {
                    proposal.setFileLocation(location);
                }
                proposals.add(proposal);
            }
            ++n2;
        }
        return proposals;
    }

    protected List<ICompletionProposal> addRubleProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            String scope = this.getDocumentScopeManager().getScopeAtOffset(viewer, offset);
            List commands = this.getBundleManager().getContentAssists((IModelFilter)new ScopeFilter(scope));
            if (!CollectionsUtil.isEmpty((Collection)commands)) {
                Ruby ruby = Ruby.newInstance();
                for (ContentAssistElement ce : commands) {
                    proposals.addAll(this.addRubleCAProposals(viewer, offset, ruby, ce));
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        proposals.trimToSize();
        return proposals;
    }

    protected Collection<ICompletionProposal> addSnippetProposals(ITextViewer viewer, int offset) {
        if (viewer != null && viewer.getSelectionProvider() != null) {
            PerformanceStats stats = null;
            if (PerformanceStats.isEnabled((String)SNIPPET_PERF)) {
                stats = PerformanceStats.getStats((String)SNIPPET_PERF, (Object)"SnippetsCompletionProcessor");
                stats.startRun();
            }
            ICompletionProposal[] snippets = new SnippetsCompletionProcessor().computeCompletionProposals(viewer, offset);
            if (stats != null) {
                stats.endRun();
            }
            if (snippets == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(snippets);
        }
        return Collections.emptyList();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        Index index = this.getIndex();
        if (index != null) {
            this.computeCompletionProposalsUsingIndex(viewer, offset, index, completionProposals);
        }
        return completionProposals.toArray(new ICompletionProposal[completionProposals.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        PerformanceStats stats = null;
        try {
            if (PerformanceStats.isEnabled((String)PERFORMANCE_EVENT_PREFIX)) {
                stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT_PREFIX, (Object)this);
                stats.startRun();
            }
            List<ICompletionProposal> rubleProposals = this.addRubleProposals(viewer, offset);
            Collection<ICompletionProposal> snippetProposals = this.addSnippetProposals(viewer, offset);
            Collection proposals = CollectionsUtil.union(rubleProposals, snippetProposals);
            ICompletionProposal[] others = this.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated);
            if (others == null) {
                others = NO_PROPOSALS;
            }
            if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/content_assist")) {
                IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Generated {0} ruble proposals, {0} snippet proposals, and {0} language proposals", rubleProposals.size(), snippetProposals.size(), others.length), (String)"com.aptana.editor.common/debug/content_assist");
            }
            ICompletionProposal[] combined = new ICompletionProposal[proposals.size() + others.length];
            proposals.toArray(combined);
            System.arraycopy(others, 0, combined, proposals.size(), others.length);
            if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/content_assist")) {
                IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Combined {0} total proposals", combined.length), (String)"com.aptana.editor.common/debug/content_assist");
            }
            this.sortProposals(combined);
            ICompletionProposal[] iCompletionProposalArray = combined;
            return iCompletionProposalArray;
        }
        finally {
            if (stats != null) {
                stats.endRun();
            }
        }
    }

    protected void computeCompletionProposalsUsingIndex(ITextViewer viewer, int offset, Index index, List<ICompletionProposal> completionProposals) {
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public void dispose() {
        if (this.getPreferenceNodeQualifier() != null) {
            InstanceScope.INSTANCE.getNode(this.getPreferenceNodeQualifier()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        return this.computeCompletionProposals(viewer, offset);
    }

    public String[] getActiveUserAgentIds() {
        return UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
    }

    protected Image[] getAllUserAgentIcons() {
        return UserAgentManager.getInstance().getUserAgentImages(this.getProject(), new String[0]);
    }

    protected IParseNode getAST() {
        return this.editor.getAST();
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this._completionProposalChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this._contextInformationChars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    public String getErrorMessage() {
        return null;
    }

    protected String getFilename() {
        return this.editor.getEditorInput().getName();
    }

    protected Index getIndex() {
        return EditorUtil.getIndex(this.editor);
    }

    protected String getPreferenceNodeQualifier() {
        return null;
    }

    protected IProject getProject() {
        return EditorUtil.getProject(this.editor);
    }

    protected URI getProjectURI() {
        return EditorUtil.getProjectURI(this.editor);
    }

    public char[] getProposalTriggerCharacters() {
        return this._proposalTriggerChars;
    }

    protected URI getURI() {
        return EditorUtil.getURI((IEditorPart)this.editor);
    }

    public boolean isActiveByUserAgent(String[] userAgents) {
        boolean result = false;
        if (userAgents == null || userAgents.length == 0) {
            result = true;
        } else {
            block0 : switch (this._filterType) {
                case NO_FILTER: {
                    result = true;
                    break;
                }
                case ONE_OR_MORE: {
                    String[] userAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
                    HashSet<String> activeNameSet = new HashSet<String>(Arrays.asList(userAgentIds));
                    String[] stringArray = userAgents;
                    int n = userAgents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (activeNameSet.contains(id)) {
                            result = true;
                            break block0;
                        }
                        ++n2;
                    }
                    break;
                }
                case ALL: {
                    HashSet<String> nameSet = new HashSet<String>(Arrays.asList(userAgents));
                    String[] activeUserAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
                    result = nameSet.containsAll(Arrays.asList(activeUserAgentIds));
                    break;
                }
            }
        }
        return result;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return false;
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return false;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("completionProposalActivationCharacters".equals(key)) {
            this._completionProposalChars = this.retrieveCAPreference("completionProposalActivationCharacters");
        } else if ("contextInformationActivationCharacters".equals(key)) {
            this._contextInformationChars = this.retrieveCAPreference("contextInformationActivationCharacters");
        } else if ("proposalTriggerCharacters".equals(key)) {
            this._proposalTriggerChars = this.retrieveCAPreference("proposalTriggerCharacters");
        }
    }

    private char[] retrieveCAPreference(String preferenceKey) {
        String chars = this.retrievePreference(preferenceKey);
        return chars != null ? chars.toCharArray() : null;
    }

    private String retrievePreference(String preferenceKey) {
        String qualifier = this.getPreferenceNodeQualifier();
        if (qualifier == null) {
            return null;
        }
        return Platform.getPreferencesService().getString(this.getPreferenceNodeQualifier(), preferenceKey, "", null);
    }

    protected void setSelectedProposal(String prefix, ICompletionProposal[] proposals) {
        if (StringUtil.isEmpty((String)prefix) || proposals == null) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String displayString = proposal.getDisplayString();
            int comparison = displayString.compareToIgnoreCase(prefix);
            if (comparison >= 0 && displayString.toLowerCase().startsWith(prefix.toLowerCase())) {
                ICommonCompletionProposal common = (ICommonCompletionProposal)proposal;
                if (displayString.equalsIgnoreCase(prefix)) {
                    if (common.getRelevance() < 100) {
                        common.setRelevance(100);
                    }
                } else if (displayString.startsWith(prefix)) {
                    if (common.getRelevance() < 90) {
                        common.setRelevance(90);
                    }
                } else if (common.getRelevance() < 50) {
                    common.setRelevance(50);
                }
            }
            ++n2;
        }
    }

    protected void sortProposals(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, CompletionProposalComparator.descending(CompletionProposalComparator.getComparator(CompletionProposalComparator.RelevanceSort, CompletionProposalComparator.NameSort)));
    }
}

